{{--
  Title: Text Section with Two Images
  Description: Text Section with Two Images
  Category: montway_blocks
  Icon: admin-comments
  Keywords: text images
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/image.png
--}}
@php
  $title = get_field('title');
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $sections = get_field("section");
  $vertical_line = get_field('vertical_line');

@endphp
<section data-{{ $block['id'] }} class="text-two-images">
  <div class="container position-relative">
    <div class="row">
      <div class="col-12">
        <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
      </div>
    </div>
    @php
      $rowCount = 0;
    @endphp
    @foreach($sections as $section)
      @php
        $i = 0;
      @endphp
      @if($rowCount++ % 2 == 1)
        <div class="row  section-row ">
          <div class="col-lg-6  pb-0 pb-lg-5 mb-5 mb-lg-0">
            <div class="img-wrap position-relative d-flex justify-content-start">
              @if(!empty($section['images']))
                @foreach($section['images'] as $image)
                  @php
                    $i++;
                    $images = \App\Controllers\App::imageWithAlt($image);
                  @endphp
                  @if($i === 1)
                    <div class="img-large-wrap">
                      <img src="{!! $images['image'] !!}" alt="{!! $images['alt'] !!}"
                        srcset="{!! $images['small'] . $images['medium'] . $images['large'] !!}">
                    </div>
                  @else
                    <div class="img-absolute small right">
                      <img src="{!! $images['image'] !!}" alt="{!! $images['alt'] !!}"
                        srcset="{!! $images['small'] . $images['medium'] . $images['large'] !!}">
                    </div>
                  @endif
                @endforeach

              @endif
            </div>
          </div>
          <div class="col-lg-4 offset-lg-1 js-parent-container-open">
            <div class="js-container-toggle">
              <h3 class="mb-3 text-regular">{!! $section['title'] !!}</h3>
              <div class="text-gray blue-marker body-link">{!! $section['body__copy'] !!}</div>
              <div class="text-gray item-hidden blue-marker body-link">{!! $section['body_copy_hidden'] !!}</div>
              @if($section['body_copy_hidden'])
                <button data-text-open="Read less" data-text-close="Read more"
                  class="is-underline p-0 js-button-trigger js-see-more-button mt-3"><span
                    class="js-button-text">Read more</span></button>
              @endif
              @if($section['button']['button_link'])
                <a href="{!! $section['button']['button_link'] !!}" class="button-primary">{!!
                  $section['button']['button_text'] !!}</a>
              @endif
            </div>
          </div>
          @if($vertical_line == "yes")
          <div class="dashed-line-dot  desk-only"></div>
          @endif
        </div>
      @else
        <div class="row section-row ">
          <div class="col-lg-4 order-2 order-lg-1 js-parent-container-open">
            <div class="js-container-toggle">
            <h3 class="mb-3 text-regular">{!! $section['title'] !!}</h3>
            <div class="text-gray blue-marker body-link">{!! $section['body__copy'] !!}</div>
            <div class="text-gray item-hidden blue-marker body-link">{!! $section['body_copy_hidden'] !!}</div>
            @if($section['body_copy_hidden'])
              <button data-text-open="Read less" data-text-close="Read more"
                class="is-underline p-0 js-button-trigger js-see-more-button mt-3"><span
                  class="js-button-text">Read more</span></button>
            @endif
            @if($section['button']['button_link'])
              <a href="{!! $section['button']['button_link'] !!}">{!! $section['button']['button_text'] !!}</a>
            @endif
          </div>
        </div>

          <div class="col-lg-6 offset-lg-2 order-1 order-lg-2 pb-0 pb-sm-0 pb-lg-5 mb-5 mb-lg-0">
            <div class="img-wrap position-relative d-flex justify-content-end">
              @if(!empty($section['images']))
                @foreach($section['images'] as $image)
                  @php

                    $i++;
                    $images = \App\Controllers\App::imageWithAlt($image);
                  @endphp
                  @if($i === 1)
                    <div class="img-large-wrap">
                      <img src="{!! $images['image'] !!}" alt="{!! $images['alt'] !!}"
                        srcset="{!! $images['small'] . $images['medium'] . $images['large'] !!}">
                    </div>
                  @else
                    <div class="img-absolute small left">
                      <img src="{!! $images['image'] !!}" alt="{!! $images['alt'] !!}"
                        srcset="{!! $images['small'] . $images['medium'] . $images['large'] !!}">
                    </div>
                  @endif
                @endforeach


              @endif
            </div>
          </div>
          @if($vertical_line == "yes")
          <div class="dashed-line-dot  desk-only"></div>
          @endif
        </div>
      @endif
    @endforeach

    @if($vertical_line == "yes")
      <div class="js-dashed-line dashed-two-images desk-only">
        <div class="animated-line js-animated-line line-2">
          <div class="pulsating-dot"></div>
        </div>
      </div>
      <div class="dashed-line  dashed-two-images desk-only"></div>
    @endif
  </div>
</section>
