{{--
  Title: Text Section V2
  Description: Text Section V2
  Category: montway_blocks
  Icon: admin-comments
  Keywords: text
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/text-section-v2.png
--}}
@php
  $title = get_field('title');
  $body_copy = get_field('body_copy');
  $body_copy_hidden = get_field('body_copy_hidden');
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  $button = get_field('button');
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="text-section-normal text-section-v2 bg-light ">
  <div class="container">
    <div class="row">
      <div class="col-12 ">
        <div class="js-parent-container-open fade-in-animation box-with-shadow">
          <div class="js-container-toggle">
            <h3 class="mb-4 h3">{!! $title !!}</h3>
            <div class="body-link">{!! $body_copy !!} </div>
            <div class="item-hidden body-link">{!! $body_copy_hidden !!}</div>
            @if($body_copy_hidden)
              <button data-text-open="Read less" data-text-close="Read more"
                      class="is-underline p-0 js-button-trigger js-see-more-button d-block mb-3 mt-3">
                <span class="js-button-text">Read more</span></button>
            @endif
            @if($button['button_link'])
              <a href="{!! $button['button_link'] !!}" class="button-primary">{!! $button['button_text'] !!}</a>
            @endif
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
