{{--
  Title: Title and Icons Module
  Description: Title and Icons Module
  Category: montway_blocks
  Icon: admin-comments
  Keywords: title icons
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/title-icons.png
--}}
@php
  $title = get_field("title");
  $icon_block = get_field("icon_group");
  $icon_block_second = get_field('icon_second_group');
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="bg-light title-icons-section">
  <div class="container">
    <div class="row">
      <div class=" col-lg-6">
        <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
        <div class="mr-lg-5">

          @foreach($icon_block as $block)
            <div class="box-icon-text has-border js-container-toggle">
              @php
                if(!empty($block['icon'])){
                $img = \App\Controllers\App::imageWithAlt($block['icon']);
                $img_type = \App\Controllers\App::checkImgExtension($block['icon']['filename']);
                }
              @endphp
              @if(isset($img))
                @if($img_type == "svg")
                  <span class="box-icon p-absolute">
                    @php
                      echo file_get_contents($img['image'])
                    @endphp
                  </span>
                @else
                  <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
                    srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}" />
                @endif
              @endif
              <h3 class="h5 ">{!! $block['text'] !!}</h3>
            </div>
          @endforeach
        </div>
      </div>
      <div class="col-lg-5 offset-lg-1">


        @foreach($icon_block_second as $block)
          <div class="box-icon-text has-border js-container-toggle">
            @php
              if(!empty($block['icon'])){
              $img = \App\Controllers\App::imageWithAlt($block['icon']);
              $img_type = \App\Controllers\App::checkImgExtension($block['icon']['filename']);
              }
            @endphp
            @if(isset($img))
              @if($img_type == "svg")
                <span class="box-icon p-absolute">
                  @php
                    echo file_get_contents($img['image'])
                  @endphp
                </span>
              @else
                <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
                  srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}" />
              @endif
            @endif
            <h3 class="h5 ">{!! $block['text'] !!}</h3>
          </div>
        @endforeach
      </div>
    </div>
  </div>
</section>
