{{--
  Title: Twitter Module
  Description: Twitter Module
  Category: montway_blocks
  Icon: admin-comments
  Keywords: twitter comments
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/twitter.png
--}}
@php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $title = get_field('title');

  $tweet_engine = new \App\Controllers\Twitter;

@endphp
<section data-{{ $block['id'] }} class="twitter-section">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
      </div>
      <div class="col-12">
        <div class="twitter-wrap">
          @php
            $rowCount = 0;
            $row_zindex = count(get_field('tweets'));
          @endphp
          @if(have_rows('tweets'))
            @while(have_rows('tweets'))
              @if($rowCount++ % 2 == 1)
                @php
                  the_row()
                @endphp
                <div class="twitter-card twitter-right" style="z-index: {{$row_zindex}}">
                  <div class="t-box">
                    {!! get_sub_field('tweet') !!}
                  </div>
                </div>
              @else
                @php
                  the_row()
                @endphp
                <div class="twitter-card twitter-left" style="z-index: {{$row_zindex}}">
                  <div class="t-box">
                    {!! get_sub_field('tweet') !!}
                  </div>
                </div>
              @endif
              @php
                  $row_zindex--;
              @endphp
            @endwhile
            <div class="twitter-timeline"></div>
        </div>
        @endif
      </div>
    </div>
  </div>
</section>
