{{--
  Title: Two logo images with text above
  Description: Two logo images with text above
  Category: montway_blocks
  Icon: admin-comments
  Keywords: text image logo
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/two-logos-text-above.png
--}}
@php
  $title = get_field('title');
  $body_copy = get_field('body_copy');
  $left_group = get_field('left_logo');
  $right_group = get_field('right_logo');
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="logos-press">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h2 class="mb-4">{!! $title !!}</h2>
        <div class="text-gray body-link">{!! $body_copy !!}</div>
      </div>
      <div class="col-lg-7 mx-auto d-flex flex-column flex-sm-row justify-content-center mt-4">
        <div class="d-flex flex-column align-items-center justify-content-between pr-sm-4">
          <p class="p-4">{!! $left_group['title'] !!}</p>
          @php
            if(!empty($left_group['image'])){
            $img = \App\Controllers\App::imageWithAlt($left_group['image']);
            $img_type = \App\Controllers\App::checkImgExtension($left_group['image']['filename']);
            }
          @endphp
          <div>

          @if(isset($img))
            @if($img_type == "svg")
              @php
                echo file_get_contents($img['image'])
              @endphp
            @else
              <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
                srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}" class="vertical-logo" />
            @endif
          @endif
        </div>

          <span class="mt-4">{!! $left_group['underline'] !!}</span>
        </div>

        <div class="d-flex flex-column align-items-center justify-content-between pl-sm-5">
          <p class="p-4">{!! $right_group['title'] !!}</p>
          @php
            if(!empty($right_group['image'])){
            $img = \App\Controllers\App::imageWithAlt($right_group['image']);
            $img_type = \App\Controllers\App::checkImgExtension($right_group['image']['filename']);
            }
          @endphp
          @if(isset($img))
          <div>

            @if($img_type == "svg")
            @php
                echo file_get_contents($img['image'])
                @endphp
            @else
            <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
            srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}" />
            @endif
          </div>
            @endif
          <span class="mt-4">{!! $right_group['underline'] !!}</span>
        </div>
      </div>
    </div>
  </div>
</section>
