<!doctype html>
<html {!! get_language_attributes() !!}>
  @include('partials.head')
  <body @php body_class() @endphp>
    @php
      echo get_theme_mod( 'open_body_script' );
    @endphp
    <div class="outer-container mx-auto">
      @php do_action('get_header') @endphp
      @include('partials.header')
      <div class="wrap " role="document">
        <div class="content">
          <main class="main">
            @yield('content')
          </main>
          @if (App\display_sidebar())
            <aside class="sidebar">
              @include('partials.sidebar')
            </aside>
          @endif
        </div>
      </div>
      @php do_action('get_footer') @endphp
      @include('partials.footer')
      @php wp_footer() @endphp
    </div>
    @if ( is_singular( 'post' ) )
    <div class="progres-wrap position-fixed w-100">
      <div id="progress" class="progress"></div>
    </div>
    @endif
    @php
    echo get_theme_mod( 'close_body_script' );
    echo get_theme_mod( 'footer_script' );
    @endphp 
  </body>
</html>
