
<?php
  $section_layout = get_field("section_layout");
  $section_table = get_field('section_table');
  $section_with_button = get_field("section_with_button");
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
?>
<section data-<?php echo e($block['id']); ?>>
  <div class="container">
    <!-- image text section with table -->
    <?php if($section_layout == "with_table"): ?>
      <div class="row image-text-table">
        <div class="col-lg-6 order-2 order-lg-1 swiper-container table-swiper">
          <div class="swiper-wrapper">
            <?php
              if(!empty($section_table['images'])){
              foreach ($section_table['images'] as $item) {
              $image = \App\Controllers\App::imageWithAlt($item);
              $image_type = \App\Controllers\App::checkImgExtension($item['filename']);
            ?>
            <?php if(isset($image)): ?>
            <div class="swiper-slide">
              <?php if($image_type == "svg"): ?>
                <?php
                  echo file_get_contents($image['image'])
                ?>
              <?php elseif(preg_match('/^.*\.(mp4|mov|mpg|mpeg|wmv|mkv|webm)$/i', $image['image'])): ?>
                <video controls loop autoplay muted>
                  <source src="<?php echo $image['image']; ?>">
                </video>
              <?php else: ?>

                  <img src="<?php echo $image['image']; ?>" alt="<?php echo $image['alt']; ?>"
                    srcset="<?php echo $image['small'] . $image['medium'] . $image['large']; ?>">

              <?php endif; ?>
            </div>
            <?php endif; ?>
            <?php
              }
              }
            ?>

          </div>
          <div class="swiper-pagination table-pagination"></div>
          <div class="swiper-button-prev table-prev"></div>
          <div class="swiper-button-next table-next"></div>
        </div>
        <div class="col-lg-6 order-1 mb-4 mb-lg-0 order-lg-2">
          <h2 class=" mb-4"><?php echo $section_table['title']; ?></h2>
          <div class="mb-3 body-link"><?php echo $section_table['body_copy']; ?></div>
          <?php echo $section_table['table']; ?>

        </div>
      </div>
    <?php else: ?>
      <!-- image text section with read me button -->
      <div class="row">
        <div class="col-lg-6 order-2 order-lg-1 ">
          <div class="swiper-container table-swiper">
            <div class="swiper-wrapper">
              <?php
                if(!empty($section_with_button['images'])){
                foreach ($section_with_button['images'] as $item) {
                $image = \App\Controllers\App::imageWithAlt($item);
                $image_type = \App\Controllers\App::checkImgExtension($item['filename']);
              ?>
              <?php if(isset($image)): ?>
                <?php if($image_type == "svg"): ?>
                  <?php
                    echo file_get_contents($image['image'])
                  ?>
                <?php else: ?>
                  <div class="swiper-slide">
                    <img src="<?php echo $image['image']; ?>" alt="<?php echo $image['alt']; ?>"
                      srcset="<?php echo $image['small'] . $image['medium'] . $image['large']; ?>">
                  </div>
                <?php endif; ?>
              <?php endif; ?>
              <?php
                }
                }
              ?>
            </div>
            <div class="swiper-pagination table-pagination"></div>
            <div class="swiper-button-prev table-prev"></div>
            <div class="swiper-button-next table-next"></div>
          </div>
        </div>
        <div class="col-lg-6 js-parent-container-open order-1 mb-4 mb-lg-0 order-lg-2">
          <div class="js-container-toggle">
            <h2 class=" mb-4"><?php echo $section_with_button['title']; ?></h2>
            <div class="text-gray body-link"><?php echo $section_with_button['body_copy']; ?></div>
            <div class="item-hidden text-gray body-link"><?php echo $section_with_button['body_copy_hidden']; ?></div>
            <?php if($section_with_button['button']): ?>
              <button data-text-open="Read less" data-text-close="Read more"
                class="is-underline p-0 js-button-trigger js-see-more-button mt-3"><span
                  class="js-button-text">Read more</span></button>
            <?php endif; ?>
          </div>
        </div>
      </div>
    <?php endif; ?>
  </div>
</section>
