
<?php
  $title = get_field('title');
  $body_copy = get_field('body_copy');
  $padding = get_field('block_padding');
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $column_layout = get_field('column_layout');
?>
<section data-<?php echo e($block['id']); ?> class="<?php echo e(( $column_layout == 'four' ) ? 'bg-light' : 'bg-white'); ?> text-4-col mw-100">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <?php if( $title ): ?>
        <h2 class="mb-4 mb-lg-5"><?php echo $title; ?></h2>
        <?php endif; ?>
        <div class="mb-4 body-link"><?php echo $body_copy; ?></div>
      </div>

      <div class="col-12">
        <?php if($column_layout == 'four'): ?>
        <div class="col-grid">
          <?php if(have_rows('columns')): ?>
            <?php while(have_rows('columns')): ?>
              <?php
                the_row();
                $text = get_sub_field('text');
                $icon = get_sub_field('icon');
                if(!empty($icon)){
                $image = \App\Controllers\App::imageWithAlt($icon);
                $image_type = \App\Controllers\App::checkImgExtension($icon['filename']);
                }
              ?>
              <div class="d-flex align-items-center flex-column py-4">
                <div class="logo-wrap">
                    <img src="<?php echo $image['image']; ?>" alt="<?php echo $image['alt']; ?>"
                      srcset="<?php echo $image['small'] . $image['medium'] . $image['large']; ?>">
                </div>
                <span class="desc"><?php echo $text; ?></span>
              </div>
            <?php endwhile; ?>
            <?php endif; ?>
        </div>
        <?php else: ?>
          <!-- 3 columns grid -->
          <div class="col-grid col-grid-3">
            <?php if(have_rows('columns')): ?>
              <?php while(have_rows('columns')): ?>
                <?php
                  the_row();
                  $text = get_sub_field('text');
                  $icon = get_sub_field('icon');
                  if(!empty($icon)){
                  $image = \App\Controllers\App::imageWithAlt($icon);
                  $image_type = \App\Controllers\App::checkImgExtension($icon['filename']);
                  }
                ?>
                <div class="d-flex align-items-center flex-column py-4">
                  <div class="logo-wrap">
                    <img src="<?php echo $image['image']; ?>" alt="<?php echo $image['alt']; ?>"
                         srcset="<?php echo $image['small'] . $image['medium'] . $image['large']; ?>">
                  </div>
                  <span class="desc font-weight-bold"><?php echo $text; ?></span>
                </div>
              <?php endwhile; ?>
            <?php endif; ?>
          </div>
        <?php endif; ?>
      </div>

    </div>
  </div>
</section>
