
<?php
$title = get_field('title');
$undertitle = get_field('undertitle');
$padding = get_field('block_padding');
$inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
echo $inline_style;
?>
<section class="col-12 mb-3 table-boxes-block" data-<?php echo e($block['id']); ?> >
    <h2 class="mb-3 mb-lg-4"><?php echo $title; ?></h2>
    <h3 class="text-normal mb-4"><?php echo $undertitle; ?></h3>
    <div class="table-box-wrap d-flex flex-column flex-lg-row justify-content-between">
      <div class="w-100 mr-lg-5 mb-5 mb-lg-0">
          <?php if(have_rows('table')): ?>
              <?php while(have_rows('table')): ?>
                  <?php the_row();
                  ?>
             <table>
              <thead>
              <tr>
                <?php if(have_rows('table_head')): ?>
                  <?php while(have_rows('table_head')): ?>
                    <?php the_row(); ?>
                    <th><?php echo get_sub_field('head_text'); ?></th>
                  <?php endwhile; ?>

                <?php endif; ?>
              </tr>
              </thead>
               <tbody>
                <?php if(have_rows('table_body')): ?>
                  <?php while(have_rows('table_body')): ?>
                      <?php the_row(); ?>
                      <tr>
                      <td><?php echo get_sub_field('first_column'); ?></td>
                      <td><?php echo get_sub_field('second_column'); ?></td>
                      </tr>
                  <?php endwhile; ?>
                <?php endif; ?>
               </tbody>
             </table>
                <span class="text-gray mt-3 d-block"><?php echo get_sub_field('estimate'); ?></span>
              <?php endwhile; ?>
          <?php endif; ?>
      </div>
      <div>
        <?php if(have_rows('group')): ?>
            <?php while(have_rows('group')): ?>
            <div class="box-icon-text has-border">
                <?php the_row();
                  if(get_sub_field('icon')){
                      $img = get_sub_field('icon');
                      $image = \App\Controllers\App::imageWithAlt(get_sub_field('icon'));
                      $image_type = \App\Controllers\App::checkImgExtension($img['filename']);
                    }
                ?>

                <div class="d-flex align-items-center mb-3 mb-lg-0">
                <?php if(isset($image)): ?>
                <span class="box-icon p-absolute mr-3 mr-lg-0">
                  <?php if($image_type == "svg"): ?>
                    <?php
                      echo file_get_contents($image['image'])
                    ?>
                  <?php else: ?>
                    <img src="<?php echo $image['image']; ?>" alt="<?php echo $image['alt']; ?>" >
                  <?php endif; ?>
                </span>
                <?php endif; ?>
                <h4 class="h5 bold-desc mb-0 mb-lg-3"><?php echo get_sub_field('title'); ?></h4>
              </div>
                <div class="text-gray body-copy-b "><?php echo get_sub_field('body_copy'); ?></div>
              </div>
            <?php endwhile; ?>
        <?php endif; ?>
      </div>
    </div>
</section>
