
<?php
  $title = get_field("title");
  $img = get_field("image");
  $questions = get_field("questions");
  if(!empty($img)){
  $image = \App\Controllers\App::imageWithAlt($img);
  $image_type = \App\Controllers\App::checkImgExtension($img['filename']);
  }

  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

?>
<section data-<?php echo e($block['id']); ?> class="bg-light faq-full-width">
  <div class="container">
    <div class="row">
      <div class="col-12 col-lg-8 d-flex align-items-end">
        <h2><?php echo $title; ?></h2>
      </div>
      <div class="d-none d-lg-block col-lg-3 offset-lg-1">
        <div class="img-wrap">
          <?php if(isset($image)): ?>
            <?php if($image_type == "svg"): ?>
              <?php
                echo file_get_contents($image['image'])
              ?>
            <?php else: ?>
              <img src="<?php echo $image['image']; ?>" alt="<?php echo $image['alt']; ?>"
                srcset="<?php echo $image['small'] . $image['medium'] . $image['large']; ?>">
            <?php endif; ?>
          <?php endif; ?>
        </div>
      </div>
      <div class="col-12 mt-4">
        <div class="accordions-wrap">
          <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="accordion-item">
              <h3 class="h5 my-1 js-accordion-trigger d-flex align-items-start justify-content-between">
                <span><?php echo $question['question']; ?></span>
                <i class="icon icon-keyboard_arrow_right"></i></h3>
              <div class="text-body body-link"><?php echo $question['answer']; ?></div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>
    </div>
  </div>
</section>
