
<?php
  $title = get_field("title");
  $boxes = get_field("boxes");
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

?>
<section data-<?php echo e($block['id']); ?> class="bg-light two-by-two">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <?php if( !empty( $title ) ): ?>
          <h2 class="mb-4 mb-lg-5"><?php echo $title; ?></h2>
        <?php endif; ?>
      </div>
      <?php $__currentLoopData = $boxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $box): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
          if(!empty($box['icon'])){
          $icon = \App\Controllers\App::imageWithAlt($box['icon']);
          $icon_type = \App\Controllers\App::checkImgExtension($box['icon']['filename']);
          }
        ?>
        <div class="col-lg-6 mb-3 mb-lg-5 ">
            <div class="box-wrap box-icon-text bg-white box-v3 js-container-toggle">
              
              <div class="d-block d-lg-flex">

                <?php if($icon_type == "svg"): ?>
                  <span class="icon-montway d-none d-lg-block mr-4 ">
                  <?php
                    echo file_get_contents($icon['image'])
                  ?>
                </span>
                <?php else: ?>
                <span class="icon-montway d-none d-lg-block mr-4 ">
                  <img class="icon-montway" src="<?php echo $icon['image']; ?>" alt="<?php echo $icon['alt']; ?>"
                       srcset="<?php echo $icon['small'] . $icon['medium'] . $icon['large']; ?>">
                </span>
                <?php endif; ?>
                <div>
                  <div class="d-flex align-items-center justify-content-between mb-lg-2">
                    <div class="d-flex align-items-center">
                      <img class="icon-montway d-block d-lg-none mr-3 mr-lg-0" src="<?php echo $icon['image']; ?>" alt="<?php echo $icon['alt']; ?>"
                           srcset="<?php echo $icon['small'] . $icon['medium'] . $icon['large']; ?>">
                      <h3 class="h4"><?php echo $box['title']; ?></h3>
                    </div>
                    <i class="icon icon-keyboard_arrow_right"></i>
                  </div>

                  <div class="text-wrap body-link"><?php echo $box['body_copy']; ?></div>
                </div>
              </div>
            </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  </div>
</section>
