
<?php
  $slider_type = get_field("display_type");
  $display_reviews = get_field("single_rating");
  $padding = get_field("block_padding");
   $title = get_field('title');
   $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
?>
<section data-<?php echo e($block['id']); ?>  class="bg-white ratings">
  <div class="container">
    <div class="row justify-content-between">
      <?php if(!empty($title)): ?>
      <div class="col-12 d-none d-lg-flex align-items-center mb-4 mb-lg-5">

        <h3 class="mr-4 h2 flex-none"><?php echo $title; ?></h3>
        <hr class="separator">
      </div>
      <?php endif; ?>
    <?php if($slider_type == "four_line"): ?>
      <?php $__currentLoopData = $display_reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="col-12 col-sm-6 mb-3 mb-xl-0 col-xl-3">
          <div class="rating-box">
            <?php
            $stars = \App\Controllers\App::startRating($review['average_rating']);

            $review_logo_type = \App\Controllers\App::checkImgExtension($review['company_logo']['filename']);
            $review_logo = \App\Controllers\App::imageWithAlt($review['company_logo']);
          ?>
            <div>
              <p class="p text-gray"><?php echo $review['company_name']; ?></p>
              <div class="d-flex stars-wrap">

                <?php for($i=0; $i<$stars['full']; $i++): ?>
                <img src=<?php echo get_template_directory_uri() . '/assets/images/review-page-star.png'; ?> />
                <?php endfor; ?>
                <?php if(isset($stars['half'])): ?>
                <img src=<?php echo get_template_directory_uri() . '/assets/images/review-page-'.$stars['half'].'.png'; ?> />
                <?php endif; ?>
              </div>
              <span class="text-small text-gray-medium">(<?php echo $review['number_of_ratings']; ?> reviews)</span>
            </div>
            <div class="d-flex align-items-center flex-md-column rating-box-width">
              <span class=" rating text-gray mr-2 mr-md-0"><?php echo $review['average_rating']; ?></span>




              <?php if($review_logo_type == "svg"): ?>
              <?php
                  echo file_get_contents($review_logo['image'])
                  ?>
              <?php else: ?>
              <img src="<?php echo $review_logo['image']; ?>" alt="<?php echo $review_logo['alt']; ?>" srcset="<?php echo $review_logo['small'] . $review_logo['medium'] . $review_logo['large']; ?>">
              <?php endif; ?>
           </div>
          </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      <?php else: ?>
        <!-- Three Box display  -->
          <?php $__currentLoopData = $display_reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-12 col-sm-6 mb-3 mb-xl-0 col-xl-3">
              <div class="rating-box">
                <?php
                  $stars = \App\Controllers\App::startRating($review['average_rating']);

                  $review_logo_type = \App\Controllers\App::checkImgExtension($review['company_logo']['filename']);
                  $review_logo = \App\Controllers\App::imageWithAlt($review['company_logo']);
                ?>
                <div>
                  <p class="p text-gray"><?php echo $review['company_name']; ?></p>
                  <div class="d-flex stars-wrap">

                    <?php for($i=0; $i<$stars['full']; $i++): ?>
                      <img src=<?php echo get_template_directory_uri() . '/assets/images/review-page-star.png'; ?> />
                    <?php endfor; ?>
                    <?php if(isset($stars['half'])): ?>
                      <img src=<?php echo get_template_directory_uri() . '/assets/images/review-page-'.$stars['half'].'.png'; ?> />
                    <?php endif; ?>
                  </div>
                  <span class="text-small text-gray-medium">(<?php echo $review['number_of_ratings']; ?> reviews)</span>
                </div>
                <div class="d-flex align-items-center flex-md-column rating-box-width">
                  <?php
                    $rating = number_format((float)$review['average_rating'], 1, '.', '');
                  ?>
                  <span class=" rating text-gray mr-3 mr-md-0"><?php echo $rating; ?></span>




                  <?php if($review_logo_type == "svg"): ?>
                    <?php
                      echo file_get_contents($review_logo['image'])
                    ?>
                  <?php else: ?>
                    <img src="<?php echo $review_logo['image']; ?>" alt="<?php echo $review_logo['alt']; ?>" srcset="<?php echo $review_logo['small'] . $review_logo['medium'] . $review_logo['large']; ?>">
                  <?php endif; ?>
                </div>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      <?php endif; ?>
    </div>
  </div>
</section>
