
<?php
  $title = get_field('title');
  $padding = get_field('block_padding');
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $rating_shortcode = get_field('rating_shortcode');
?>
<section class="col-12 mb-3" data-<?php echo e($block['id']); ?> >
  <h2 class="mb-3 mb-lg-4"><?php echo $title; ?></h2>
  <div class="table-distance">
    <?php if(have_rows('table')): ?>
      <?php while(have_rows('table')): ?>
        <?php the_row();
        ?>
        <table>
          <thead>
          <tr>
            <?php if(have_rows('table_head')): ?>
              <?php while(have_rows('table_head')): ?>
                <?php the_row(); ?>
                <th><?php echo get_sub_field('text'); ?></th>
              <?php endwhile; ?>

            <?php endif; ?>
          </tr>
          </thead>
          <tbody>
          <?php if(have_rows('table_body')): ?>
            <?php while(have_rows('table_body')): ?>
              <?php the_row(); ?>
              <tr>
                <td><?php echo get_sub_field('first_column'); ?></td>
                <td><?php echo get_sub_field('second_column'); ?></td>
              </tr>
            <?php endwhile; ?>
          <?php endif; ?>
          </tbody>
        </table>
        <span><?php echo get_sub_field('estimate'); ?></span>
      <?php endwhile; ?>
    <?php endif; ?>
  </div>
</section>
<div>
  <?php echo do_shortcode($rating_shortcode); ?>
</div>
