
<?php
  $headline = get_field("title");
  $subtitle = get_field("subtitle");

  $button = get_field("button");
  $button_text = $button["button_text"];
  $button_link = $button["button_link"];

  $padding = get_field("block_padding");

  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

  $image = get_field('background_image');
  if(!empty($image)){
  $background_image = \App\Controllers\App::imageWithAlt($image);
  $background_image_type = \App\Controllers\App::checkImgExtension($image['filename']);
  }

?>

<div data-<?php echo e($block['id']); ?> class="bg-white cta-center">
  <div class="container">
    <div class="row">
      <div class="col-md-12 col-lg-9 mx-auto">
        <div class="cta-box " style="background-image: url(<?php echo $background_image['image']; ?>);">
          <?php if(!empty($headline)): ?>
            <h3 class="mb-2 h2"><?php echo $headline; ?></h3>
          <?php endif; ?>
          <?php if(!empty($subtitle)): ?>
            <div class="text body-link"><?php echo $subtitle; ?></div>
          <?php endif; ?>
          <?php if(!empty($button_link)): ?>
            <a href="<?php echo $button_link; ?>" class="button-primary"><?php echo $button_text; ?></a>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>
