
<?php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

  $steps_first = get_field('steps_first');
  $steps_second = get_field('steps_second');
  $title = get_field('title');
  $subtitle = get_field('subtitle');
?>
<section data-<?php echo e($block['id']); ?> class="progress-bar-tabs tab-container bg-gray-white">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h3 class="mb-3 h2"><?php echo $title; ?></h3>
        <h4 class="h5 bold-desc mb-4"><?php echo $subtitle; ?></h4>
      </div>
      <div class="col-12">
        <div class="steps-tabs mb-lg-3">
          <div id="tab-1" class="tab tab-button is-active">Shipping to Hawaii</div>
          <div id="tab-2" class="tab tab-button">Shipping from Hawaii</div>
        </div>

        <div class="steps-hawaii tab-1 row">
          <?php $__currentLoopData = $steps_first; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $first): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-3">
              <div class="single-step  js-parent-container-open">
                <div class="d-flex flex-column align-items-center js-container-toggle">
                  <?php
                    if(!empty($first['icon'])){
                    $img = \App\Controllers\App::imageWithAlt($first['icon']);
                    $img_type = \App\Controllers\App::checkImgExtension($first['icon']['filename']);
                    }
                  ?>
                  <?php if(isset($img)): ?>
                    <?php if($img_type == "svg"): ?>
                      <span class="icon-montway">
                        <?php
                          echo file_get_contents($img['image'])
                        ?>
                      </span>
                    <?php else: ?>
                      <img src="<?php echo $img['image']; ?>" alt="<?php echo $img['alt']; ?>">
                    <?php endif; ?>
                  <?php endif; ?>
                  <div class="d-flex flex-column align-items-center">
                    <h2 class="step-number text-blue h4 bold"><?php echo $first['label']; ?></h2>
                    <p class="h6 bold"><?php echo $first['text']; ?></p>
                    <div class="text-wrap"><?php echo $first['body_copy']; ?></div>
                    <div class="item-hidden"><?php echo $first['body_copy_hidden']; ?></div>
                    <button data-text-open="Read less" data-text-close="Read more"
                      class="is-underline p-0 js-button-trigger js-see-more-button mb-3">
                      <span class="js-button-text">Read more</span></button>
                  </div>
                </div>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <div class="steps-hawaii tab-2 row is-hidden">
          <?php $__currentLoopData = $steps_second; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $second): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-3">


              <div class="single-step js-parent-container-open">
                <div class="d-flex flex-column align-items-center js-container-toggle">

                  <?php
                    if(!empty($second['icon'])){
                    $img = \App\Controllers\App::imageWithAlt($second['icon']);
                    $img_type = \App\Controllers\App::checkImgExtension($second['icon']['filename']);
                    }
                  ?>
                  <?php if(isset($img)): ?>
                    <?php if($img_type == "svg"): ?>
                      <span class="icon-montway">
                        <?php
                          echo file_get_contents($img['image'])
                        ?>
                      </span>
                    <?php else: ?>
                      <img src="<?php echo $img['image']; ?>" alt="<?php echo $img['alt']; ?>">
                    <?php endif; ?>
                  <?php endif; ?>
                  <div class="d-flex flex-column align-items-center">
                    <h2 class="step-number text-blue h4 bold"><?php echo $second['label']; ?></h2>
                    <h5 class="h6 bold"><?php echo $second['text']; ?></h5>
                    <div class="text-wrap"><?php echo $second['body_copy']; ?></div>
                    <div class="item-hidden"><?php echo $second['body_copy_hidden']; ?></div>
                    <button data-text-open="Read less" data-text-close="Read more"
                      class="is-underline p-0 js-button-trigger js-see-more-button mb-3">
                      <span class="js-button-text">Read more</span></button>
                  </div>
                </div>
              </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>
    </div>
  </div>
</section>
