
<?php
  if(isset($page_id)){
    $title = get_field('title_hc', $page_id);
    $select = get_field('header_type_hc', $page_id);
    $subtitle = get_field('subtitle_hc', $page_id);
    $background_image_id = get_field('background_image_hc', $page_id);
    $padding = get_field("block_padding_hc", $page_id);
    $background_image_mobile_id = get_field('background_image_mobile_hc', $page_id);
  }else{
    $title = get_field('title_hc');
    $select = get_field('header_type_hc');
    $subtitle = get_field('subtitle_hc');
    $background_image_id = get_field('background_image_hc');
    $padding = get_field("block_padding_hc");
    $background_image_mobile_id = get_field('background_image_mobile_hc');
  }

  if(!isset($block['id'])){
  	$block['id'] = 'ea34tgh';
  }

  if(!empty($background_image_id)){
	$background = \App\Controllers\App::imageWithAlt($background_image_id);
	$background_type = \App\Controllers\App::checkImgExtension($background_image_id['filename']);
  }

  if(!empty($background_image_mobile_id)){
	$background_mobile = \App\Controllers\App::imageWithAlt($background_image_mobile_id);
	$background_type_mobile = \App\Controllers\App::checkImgExtension($background_image_mobile_id['filename']);
  }

  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $cats = \App\Controllers\App::returnCPTcats('helpcenter-tags');

  $hp_posts_one = get_field('selected_hp_posts_one');
  $hp_posts_two = get_field('selected_hp_posts_two');
  $hp_posts_three = get_field('selected_hp_posts_three');

  $posts_array = [$hp_posts_one, $hp_posts_two, $hp_posts_three];
  ?>
<?php if($select == 'help_center'): ?>
  <!-- Help center page header -->
<section data-<?php echo e($block['id']); ?> class="position-relative help-hero bg-gray-white single-hero" style="background: url(<?php echo $background['image']; ?>) top center no-repeat;">

  <div class="bg-mobile d-lg-none" style=" background-image: url(<?php echo $background_mobile['image']; ?>);"></div>
  <img src="<?php echo $background['image']; ?>" class="d-none" loading="eager" role="presentation">
  <img src="<?php echo $background_mobile['image']; ?>" class="d-none" loading="eager" role="presentation">
    <div class="container">
      <div class="row">
        <div class="col-12 col-lg-8 ">
          <p class="text-white mb-4 mb-lg-5 h1"><a href="/help-center/"><?php echo $title; ?></a></p>
          <div class="search-wrap">
            <p class="h3 mb-3 font-weight-normal font-family-normal"><?php echo $subtitle; ?></p>
            <form id="search_post" method="POST" action="<?php echo site_url() ?>/wp-admin/admin-ajax.php">
              <input class="input"  type="text" name="search_posts" value="" placeholder="Find anything (like cost, transport, door-to-door)" >
              <input type="hidden" name="action" value="help_center_search">
            </form>
          </div>
          <div id="search_list">
              <ul id="questions"></ul>
          </div>
        </div>
        <div class="col-lg-12 tags-bg pt-5 pb-3 pb-lg-0 pt-lg-0">
          <div class="tags-grid">
            <?php

            ?>
            <?php $__currentLoopData = $cats['cat_id']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="position-relative box-hover">
              <?php if(isset($cats['cat_name'][$key]) && isset($cats['cat_id'][$key])): ?>

                <div class="box-icon-help d-flex align-items-center justify-content-between">
                  <div class="icon-link-wrap d-flex align-items-center">
                    <span class="d-inline-block img-wrap mr-3 mr-md-4">
                      <?php
                        $cat_img_type = \App\Controllers\App::checkImgExtension($cats['cat_image'][$key]);
                      ?>
                      <?php if( $cat_img_type == 'svg' ): ?>
                        <?php echo file_get_contents( $cats['cat_image'][$key] ); ?>

                      <?php else: ?>
                        <img src="<?php echo $cats['cat_image'][$key]; ?>" />
                      <?php endif; ?>

                    </span>
                    <a class="text-blue h4 is-underline" href="<?php echo $cats['cat_url'][$key]; ?>"><?php echo $cats['cat_name'][$key]; ?></a>
                  </div>
                  <i class="icon icon-keyboard_arrow_right"></i>
                </div>
              <?php endif; ?>
              <ul class="links">
                <?php
                $posts = \App\Controllers\App::returnCPTposts("help-center", $cat, 'helpcenter-tags', 5, $posts_array[$key]);
                foreach ($posts['permalink'] as $key => $post){
                  ?>
                    <li>
                      <a class="font-small" href="<?php echo $post; ?>"><?php echo $posts['title'][$key]; ?></a>
                    </li>
                  <?php
                }
                ?>
               </ul>
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
    </div>
  </div>
</div>
</section>
<?php else: ?>
<!-- Help center category or help center tag page header -->
    <section data-<?php echo e($block['id']); ?> class="position-relative help-hero col-12" style="background-image: url(<?php echo $background['image']; ?>);">
      <img src="<?php echo $background['image']; ?>" class="d-none" loading="eager" role="presentation">
      <div class="container">
        <div class="">
          <div class="">
            <h1 class="mb-4 mb-lg-5"><a href="/help-center/"><?php echo $title; ?></a></h1>
            <div class="search-wrap col-lg-8">
              <p class="h3 mb-3 h2 font-weight-normal font-family-normal"><?php echo $subtitle; ?></p>

              <form id="search_post" method="POST" action="<?php echo site_url() ?>/wp-admin/admin-ajax.php">
                <input  type="text" name="search_posts" value="" placeholder="Find anything (like cost, transport, door-to-door)">
                <input type="hidden" name="action" value="help_center_search">
              </form>
              <div id="search_list">
                <ul id="questions"></ul>
              </div>
            </div>
          </div>
      </div>
    </div>
    </section>
<?php endif; ?>

