<?php
  $page_id = get_queried_object_id();
  $phones = \App\Controllers\App::setPhoneNumbers($page_id) ;
   $result = sprintf(
                "(%s) %s-%s",
                substr($phones, 0, 3),
                substr($phones, 3, 3),
                substr($phones, 6)
            );
?>
<?php
$headerCtaButtonType = get_field('header_button_type');
$headerCtaButton = ( $headerCtaButtonType == 'shortcode' || $headerCtaButtonType == 'hide_button') ? 'hide-default-cta' : '';
$form_header = get_field('contact_form_shordcode');
if ($headerCtaButtonType == 'shortcode') {
  $form = GFAPI::get_form( $form_header );
}
?>
<?php if($headerCtaButtonType == 'shortcode'): ?>
  <?php if($form['title'] == 'Let\'s get Started'): ?>
  <div class="modal form-modal home-delivery-form" id="formModal-<?php echo e($form_header); ?>" tabindex="-1" aria-labelledby="formModal-<?php echo e($form_header); ?>" aria-hidden="true">
    <span class="close-modal position-fixed d-flex justify-content-center align-items-center d-sm-inline-block" data-dismiss="modal"><svg viewBox="0 0 10 10" xmlns="http://www.w3.org/2000/svg"><path d="M.3 9.7c.2.2.4.3.7.3.3 0 .5-.1.7-.3L5 6.4l3.3 3.3c.2.2.5.3.7.3.2 0 .5-.1.7-.3.4-.4.4-1 0-1.4L6.4 5l3.3-3.3c.4-.4.4-1 0-1.4-.4-.4-1-.4-1.4 0L5 3.6 1.7.3C1.3-.1.7-.1.3.3c-.4.4-.4 1 0 1.4L3.6 5 .3 8.3c-.4.4-.4 1 0 1.4z" fill="#000" fill-rule="nonzero"></path></svg><span class="d-inline-block d-sm-none text-white close-text">Close</span></span>
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-body contact-form p-0">
          <div class="container-fluid">
            <div class="row">
              <div class="left-content cus-col-6">
                <div class="modal-text">
                  <h2 class="text-white">Find out how our Vehicle Home Delivery solution and Montway Business Portal can:</h2>
                  <ul class="bulleted-list mt-4">
                    <li class="text-white"><h3 class="text-white">expand your sales audience</h3></li>
                    <li class="text-white"><h3 class="text-white">engage motivated consumers</h3></li>
                    <li class="text-white"><h3 class="text-white">drive increased sales</h3></li>
                    <li class="text-white"><h3 class="text-white">simple and easy dealer website integration</h3></li>
                  </ul>
                </div>
                <div class="modal-logos d-flex justify-content-between align-items-center">
                  <img src="/app/uploads/2022/02/bbb-logo-transparent.png" alt="bbb-logo">
                  <img src="/app/uploads/2022/02/naaa_white_logo.png" alt="naaa" style="height: 60px;">
                  <img src="/app/uploads/2022/02/iara_white_logo.png" alt="iara">
                </div>
              </div>
              <div class="right-content cus-col-6">
                <?php gravity_form( $form_header , true, true, false, null, true ); ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php else: ?>
  <div class="modal form-modal" id="formModal-<?php echo e($form_header); ?>" tabindex="-1" aria-labelledby="formModal-<?php echo e($form_header); ?>" aria-hidden="true">
    <span class="close-modal position-fixed d-flex justify-content-center align-items-center d-sm-inline-block" data-dismiss="modal"><svg viewBox="0 0 10 10" xmlns="http://www.w3.org/2000/svg"><path d="M.3 9.7c.2.2.4.3.7.3.3 0 .5-.1.7-.3L5 6.4l3.3 3.3c.2.2.5.3.7.3.2 0 .5-.1.7-.3.4-.4.4-1 0-1.4L6.4 5l3.3-3.3c.4-.4.4-1 0-1.4-.4-.4-1-.4-1.4 0L5 3.6 1.7.3C1.3-.1.7-.1.3.3c-.4.4-.4 1 0 1.4L3.6 5 .3 8.3c-.4.4-.4 1 0 1.4z" fill="#000" fill-rule="nonzero"></path></svg><span class="d-inline-block d-sm-none text-white close-text">Close</span></span>
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-body contact-form contact-form-btn">
          <?php gravity_form( $form_header , true, false, false, null, true ); ?>
        </div>
      </div>
    </div>
  </div>
  <?php endif; ?>
<?php endif; ?>
<header class="banner main-header-wrap">
  <div class="top-bar ">
    <div class="moving-news">
      <div class="moving-wrapper">

        <?php
          $moving_text_array = get_field( 'additional_moving_text', 'option' );
          foreach ($moving_text_array as $mt) {
            if ( $page_id === $mt['select_page_text'] ) {
              if( !empty( $mt['new_text'] ) ) {
                $moving_text = $mt['new_text'];
              }
            }
          }
          $default_text = get_field( 'moving_text', 'option' );
        ?>
        <?php if( !empty( $moving_text ) ): ?>
          <?php echo $moving_text; ?>

        <?php else: ?>
          <?php echo $default_text; ?>

        <?php endif; ?>
      </div>
    </div>

    <?php if(has_nav_menu("top_bar_nav")): ?>
      <?php echo wp_nav_menu(['theme_location' => 'top_bar_nav', 'menu_class' => 'menu-right d-flex justify-content-between', 'add_a_class' => 'text-upper text-small', 'walker' => new Phone_Wrap()]); ?>

    <?php endif; ?>
  </div>

  <div class="navigation bg-white px-2 px-lg-4">
    <div class="logo-nav col-lg-9 d-flex align-items-center px-0">
      <button class="burger-container d-block d-xl-none" aria-label="Menu">
        <span class="hamburger-box"> <span class="hamburger-inner"></span> </span>
      </button>
      <a class="brand  pl-0" href="<?php echo e(home_url('/')); ?>"><?php echo file_get_contents( get_theme_mod( 'upload_logo' ) ); ?></a>
      <nav class="nav-primary ml-0 ml-xl-4 px-4 pl-xl-0">
        <div class="nav-background position-absolute d-none d-xl-block"></div>
        <?php if(has_nav_menu('primary_navigation')): ?>
          <?php echo wp_nav_menu(['theme_location' => 'primary_navigation', 'menu_class' => 'nav first-level', 'depth' => 0, 'walker' => new Child_Wrap()]); ?>

        <?php endif; ?>

        <?php if(has_nav_menu("cta_mob_navigation")): ?>
          <div class="mob-info d-block d-xl-none">
            <?php echo wp_nav_menu(['theme_location' => 'cta_mob_navigation', 'menu_class' => 'text-center', 'depth' => 0 , 'walker' => new Phone_Wrap()]); ?>

          </div>
        <?php endif; ?>
      </nav>
      <a href="tel:<?php echo $phones; ?>" class="text-blue d-inline-block d-xl-none button-primary cta-phone-number"><?php echo $result; ?></a>
    </div>

    <div class="part-phone col-xl-3 text-right pr-0 <?php echo ( $headerCtaButtonType == 'shortcode' ) ? 'd-none d-xl-flex align-items-center justify-content-end' : '';; ?>">
      <button class="request-demo button-primary mr-32 <?php echo ( $headerCtaButtonType == 'shortcode' ) ? 'd-none d-xl-block' : 'd-none';; ?>" data-toggle="modal" data-target="#formModal-<?php echo e($form_header); ?>">Get in touch</button>
    <?php if(has_nav_menu('cta_navigation')): ?>
      <?php echo wp_nav_menu(['theme_location' => 'cta_navigation', 'menu_class' => $headerCtaButton . ' d-inline-flex align-items-center', 'add_a_class' => '', 'walker' => new Phone_Wrap()]); ?>

    <?php endif; ?>
    </div>

  </div>

  <div class="moving-news is-mobile bg-white">
    <div class="moving-wrapper">
      <?php
      $moving_text_array = get_field( 'additional_moving_text', 'option' );
      foreach ($moving_text_array as $mt) {
        if ( $page_id === $mt['select_page_text'] ) {
          if( !empty( $mt['new_text'] ) ) {
            $moving_text = $mt['new_text'];
          }
        }
      }
      $default_text = get_field( 'moving_text', 'option' );
      ?>
      <?php if( !empty( $moving_text ) ): ?>
        <?php echo $moving_text; ?>

      <?php else: ?>
        <?php echo $default_text; ?>

      <?php endif; ?>
    </div>

  </div>

</header>
