
<?php
  $title = get_field("title");
  $logos = get_field("logos");
  $padding = get_field("block_padding");

  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
?>
<section data-<?php echo e($block['id']); ?> class="logos-section logos-slider position-relative bg-white">
  <div class="container">
    <div class="row">
      <?php if( !empty( $title ) ): ?>
        <div class="col-12">
          <h2 class="mb-4 mb-lg-5"><?php echo $title; ?></h2>
        </div>
      <?php endif; ?>
      <div class="col-12">
        <div class="logos-wrap d-lg-flex align-items-center justify-content-between swiper-container logos-swiper">
          <div class="swiper-wrapper">
            <?php $__currentLoopData = $logos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="swiper-slide">
                <div class="logo">
                  <?php if($logo['link']): ?>
                    <a href="<?php echo $logo['link']; ?>">
                  <?php endif; ?>
                  <?php
                    if(!empty($logo['logo_image'])){
                    $img = \App\Controllers\App::imageWithAlt($logo['logo_image']);
                    $img_type = \App\Controllers\App::checkImgExtension($logo['logo_image']['filename']);
                    }
                  ?>
                  <?php if(isset($img)): ?>
                    <?php if($img_type == "svg"): ?>
                      <?php
                        echo file_get_contents($img['image'])
                      ?>
                    <?php else: ?>
                      <img src="<?php echo $img['image']; ?>" alt="<?php echo $img['alt']; ?>">
                    <?php endif; ?>
                  <?php endif; ?>

                  <?php if($logo['link']): ?>
                    </a>
                  <?php endif; ?>
                </div>
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
          <div class="swiper-pagination logos-pagination"></div>
        </div>
      </div>
        <div class="swiper-button-prev logos-prev <?php echo e(( empty( $title ) ) ? 'top-half' : ''); ?>"></div>
        <div class="swiper-button-next logos-next <?php echo e(( empty( $title ) ) ? 'top-half' : ''); ?>"></div>
    </div>
  </div>
</section>
