
<?php
$title = get_field("title");
$body_copy = get_field("body_copy");
$sections = get_field("single_section");
$padding = get_field("block_padding");

   $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
?>
<section data-<?php echo e($block['id']); ?> class="bg-white industries">
  <div class="container">
    <div class="row">
      <div class="col-12">
          <?php if(!empty($title)): ?>
          <h2 class="mb-4"><?php echo $title; ?></h2>
          <?php endif; ?>

          <?php if(!empty($body_copy)): ?>
            <div class="mb-4 mb-lg-5 body-link">  <?php echo $body_copy; ?></div>
          <?php endif; ?>
      </div>

    <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <div class="col-lg-6 mb-4 mb-lg-5">
          <div class="img-wrap">
            <?php
              if(!empty($section['image'])){
              $img = \App\Controllers\App::imageWithAlt($section['image']);
              $img_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
              }
            ?>
            <?php if(isset($img)): ?>
              <?php if($img_type == "svg"): ?>
                <?php
                  echo file_get_contents($img['image'])
                ?>
              <?php else: ?>
                <img src="<?php echo $img['image']; ?>" alt="<?php echo $img['alt']; ?>" srcset="<?php echo $img['small'] . $img['medium'] . $img['large']; ?>">
              <?php endif; ?>
            <?php endif; ?>
          </div>
        <div>

            <?php if(!empty($section['title'])): ?>
                <h3 class="h3-heading"><?php echo $section['title']; ?></h3>
            <?php endif; ?>
            <?php if(!empty($section['body_copy'])): ?>
                <div class="mb-3 body-link"><?php echo $section['body_copy']; ?></div>
            <?php endif; ?>

            <?php if(!empty($section['button']['button_text'] && $section['button']['button_url'])): ?>
              <a href="<?php echo $section['button']['button_url']; ?>" class="is-underline"><?php echo $section['button']['button_text']; ?></a>
            <?php endif; ?>
        </div>
      </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
  </div>
</section>
