
<?php
  $title = get_field('title');
  $subtitle = get_field('subtitle');
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $image = get_field("logo");
  if(!empty($image)){
  $img = \App\Controllers\App::imageWithAlt($image);
  $img_type = \App\Controllers\App::checkImgExtension($image['filename']);
  }
  $logo_link = get_field('logo_link');
  $chat_url = get_field('chat_url');
  $chat_image = get_field('background_image');
  if (!empty($chat_image)) {
    $chat_background = \App\Controllers\App::imageWithAlt($chat_image);
  }
?>
<section data-<?php echo e($block['id']); ?> class="livechat bg-light">
  <div class="container">
    <div class="row">
      <div class="col-lg-8 mx-auto text-center">
        <?php if(!empty($img)): ?>
          <a class="mb-4 img-wrap d-block mx-auto" href="<?php echo $logo_link; ?>">
            <?php if($img_type == "svg"): ?>
              <span class="">
                <?php
                  echo file_get_contents($img['image'])
                ?>
              </span>
            <?php else: ?>
              <img src="<?php echo $img['image']; ?>" alt="<?php echo $img['alt']; ?>"
                srcset="<?php echo $img['small'] . $img['medium'] . $img['large']; ?>" alt="">
            <?php endif; ?>
          </a>
        <?php endif; ?>
        <h2 class="h4 mb-3"><?php echo $title; ?></h2>
        <p class="mb-32"><?php echo $subtitle; ?></p>
      </div>
    </div>
  </div>
  <div class="chat-wrap w-100 d-flex justify-content-center" style="background-image: url(<?php echo (!empty($chat_background)) ? $chat_background['image'] : ''; ?>)">
    <div class="chat-iner">
      <div class="chat-loader w-100 h-100 align-items-center justify-content-center" style="display: flex;">
        <div class="bounce1"></div> <div class="bounce2"></div> <div class="bounce3"></div>
      </div>
      <iframe id="chat-iframe" class="w-100 h-100" src="<?php echo $chat_url; ?>" frameborder="0" style="display: none; visibility: hidden;"></iframe>
    </div>
  </div>
</section>
