
<?php
  $reviews = get_field("select_reviews");

  if(!empty($reviews)){
  $display_reviews = \App\Controllers\App::getReviews($reviews);
  }else{
  $display_reviews = \App\Controllers\App::getReviews();
  }

  $title = get_field("title");
  $slider_type = get_field("display_type");
  $padding = get_field("block_padding");

  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
?>
<section data-<?php echo e($block['id']); ?> class=" position-relative bg-white">
  <div class="container">

    <div class="row">
      <div class="col-12">
        <h4 class="h4 mb-3"><?php echo $title; ?></h4>
      </div>
      <?php if($slider_type == "three_line"): ?>
        <div class="col-12 swiper-container reviews-swiper-three-cards">
          <div class="swiper-wrapper">
            <?php $__currentLoopData = $display_reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="swiper-slide review3-box-width mr-20">
                <div class="review-box">
                  <div>
                    <div class="name-rating-wrap">
                      <span class="h4 text-caption text-gray-medium"><?php echo $review['name'][0]; ?></span>
                      <?php
                        $stars = \App\Controllers\App::startRating($review['rating'][0]);
                      ?>
                      <div class="stars-wrapper">
                        <?php for($i=0; $i<$stars['full']; $i++): ?>
                          <img class="no-lazy" src=<?php echo get_template_directory_uri() . '/assets/images/review-page-star.png'; ?> />
                        <?php endfor; ?>
                        <?php if(isset($stars['half'])): ?>
                          <img class="no-lazy" src=<?php echo get_template_directory_uri() . '/assets/images/review-page-'
                            .$stars['half'].'.png'; ?> />
                        <?php endif; ?>
                      </div>
                      <?php
                        $rating = number_format((float)$review['rating'][0], 1, '.', '');
                        ?>
                      <span class="rating"><?php echo $rating; ?></span>
                    </div>
                    <div class="review-body">
                      <p><?php echo $review['review'][0]; ?></p>
                    </div>
                  </div>
                  <div class="date-wrap">
                    <span class="text-gray-medium text-small"><?php echo $review['date'][0]; ?></span>
                    <?php
                      $review_logo_type = \App\Controllers\App::checkImgExtension($review['logo'][0]['image']);
                    ?>
                    <?php if($review_logo_type == "svg"): ?>
                      <?php
                        echo file_get_contents($review['logo'][0]['image'])
                      ?>
                    <?php else: ?>
                      <div class="img-wrap"> 
                        <img class="no-lazy" src="<?php echo $review['logo'][0]['image']; ?>" alt="<?php echo $review['logo'][0]['alt']; ?>"
                          srcset="<?php echo $review['logo'][0]['small'] . $review['logo'][0]['medium'] . $review['logo'][0]['large']; ?>">
                      </div>
                    <?php endif; ?>
                  </div>

                </div>
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
          <div class="swiper-pagination reviews-pagination"></div>
        </div>
        <div class="swiper-button-prev review-prev"></div>
        <div class="swiper-button-next review-next"></div>
      <?php else: ?>
        <!-- Two reviews per slide -->
        <div class="col-12 swiper-container reviews-swiper">
          <div class="swiper-wrapper">
            <?php $__currentLoopData = $display_reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <div class="swiper-slide review2-box-width mr-20">
                <div class="review-box">
                  <div>
                    <div class="name-rating-wrap">
                      <span class="h4 text-caption text-gray-medium"><?php echo $review['name'][0]; ?></span>
                      <?php
                        $stars = \App\Controllers\App::startRating($review['rating'][0]);
                      ?>
                      <div class="stars-wrapper">
                        <?php for($i=0; $i<$stars['full']; $i++): ?>
                          <img class="no-lazy" src=<?php echo get_template_directory_uri() . '/assets/images/review-page-star.png'; ?> />
                        <?php endfor; ?>
                        <?php if(isset($stars['half'])): ?>
                          <img class="no-lazy" src=<?php echo get_template_directory_uri() . '/assets/images/review-page-'
                            .$stars['half'].'.png'; ?> />
                        <?php endif; ?>
                      </div>
                      <?php
                        $rating = number_format((float)$review['rating'][0], 1, '.', '');
                      ?>
                      <span class="rating"><?php echo $rating; ?></span>
                    </div>
                    <div class="review-body">
                      <p><?php echo $review['review'][0]; ?></p>
                    </div>
                  </div>
                  <div class="date-wrap">
                    <span class="text-gray-medium text-small"><?php echo $review['date'][0]; ?></span>
                    <?php
                      $review_logo_type = \App\Controllers\App::checkImgExtension($review['logo'][0]['image']);
                    ?>
                    <?php if($review_logo_type == "svg"): ?>
                      <?php
                        echo file_get_contents($review['logo'][0]['image'])
                      ?>
                    <?php else: ?>
                      <div class="img-wrap">
                        <img class="no-lazy"  src="<?php echo $review['logo'][0]['image']; ?>" alt="<?php echo $review['logo'][0]['alt']; ?>"
                          srcset="<?php echo $review['logo'][0]['small'] . $review['logo'][0]['medium'] . $review['logo'][0]['large']; ?>">
                      </div>
                    <?php endif; ?>
                  </div>

                </div>
              </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
          <div class="swiper-pagination reviews-pagination"></div>
        </div>
        <div class="swiper-button-prev review-prev"></div>
        <div class="swiper-button-next review-next"></div>
      <?php endif; ?>
    </div>
  </div>
</section>
