
<?php
  $paragraph = apply_filters( 'the_content', get_field('paragraph') );
  $padding = get_field('block_padding');
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
?>
<section data-<?php echo e($block['id']); ?> class="bg-gray-white">
  <div class="container">
    <div class="row">
      <div class="col-12 mb-5">
        <div><?php echo $paragraph; ?></div>
      </div>

      <?php if(have_rows('icon_blocks')): ?>
        <?php while(have_rows('icon_blocks')): ?>
          <?php
            the_row();
            $icon = get_sub_field('icon');
            if(!empty($icon)){
            $image = \App\Controllers\App::imageWithAlt($icon);
            $image_type = \App\Controllers\App::checkImgExtension($icon['filename']);
            }
            $title = get_sub_field('title');
            $body_copy = get_sub_field('body_copy');
          ?>
          <div class="col-lg-4">
            <div class="box-icon-text">
              <div class="d-flex flex-row flex-lg-column align-items-center align-items-lg-start mb-2 mb-lg-0">
                <?php if(!empty($image)): ?>
                  <?php if($image_type == "svg"): ?>
                    <span class="d-block icon-montway icon-wrap mr-3 mb-lg-1">
                      <?php
                        echo file_get_contents($image['image'])
                      ?>
                    </span>
                  <?php else: ?>
                    <img src="<?php echo $image['image']; ?>" alt="<?php echo $image['alt']; ?>"
                      srcset="<?php echo $image['small'] . $image['medium'] . $image['large']; ?>">
                  <?php endif; ?>
                <?php endif; ?>
                <h3 class="h4 bold mb-lg-1"><?php echo $title; ?></h3>
              </div>
              <p class="text-gray"><?php echo $body_copy; ?></p>
            </div>
          </div>
        <?php endwhile; ?>
      <?php endif; ?>

    </div>
  </div>
</section>
