
<?php
  $title = get_field('title');
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

  $reviews = get_field('select_reviews');
  if(!empty($reviews)){
  $display_reviews = \App\Controllers\App::getReviews($reviews);
  }else{
  $display_reviews = \App\Controllers\App::getReviews();
  }
?>
<section data-<?php echo e($block['id']); ?> class="reviews-box-layout">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h2 class="mb-4 mb-lg-5"><?php echo $title; ?></h2>
      </div>
      <div class="col-12 mb-3">
        <div class="reviews-grid">

          <?php $__currentLoopData = array_chunk( $display_reviews, 4, true ); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $d_reviews): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php if( $i < 2 ): ?>
            <?php if( $i % 2 == 0 ): ?>
            <div class="row">
            <?php else: ?>
            <div class="row flex-row-reverse">
            <?php endif; ?>
          <?php else: ?>
            <?php if( $i % 2 == 0 ): ?>
            <div class="row d-none">
            <?php else: ?>
            <div class="row flex-row-reverse d-none">
            <?php endif; ?>
          <?php endif; ?>
              <?php $__currentLoopData = array_chunk( $d_reviews, 2, true ); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j => $d_r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if( $j % 2 == 0 ): ?>
                <div class="col-md-6 horizontal">
                <?php else: ?>
                <div class="col-md-6 vertical">
                <?php endif; ?>
                  <?php $__currentLoopData = $d_r; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo $review['external_review_link'][0]; ?>" class="review-page-box mb-3" target="_blank" rel="noopener noreferrer">
                      <h4 class="h4 mb-3"><?php echo $review['review_title'][0]; ?></h4>
                      <div class="d-flex align-items-center flex-wrap mb-3">
                        <div class="d-flex rating-star-wrap align-items-center ">
                          <div class="review-box-rating-wrap mr-2">
                            <?php
                              $rating = number_format((float)$review['rating'][0], 1, '.', '');
                            ?>
                            <span class="rating"><?php echo $rating; ?> /<span class="text-gray-medium">5</span></span>
                          </div>
                          <?php
                            $stars = \App\Controllers\App::startRating($review['rating'][0]);
                          ?>
                          <div class="stars-wrap mr-md-3">
                            <?php for($i=0; $i<$stars['full']; $i++): ?>
                              <img src=<?php echo get_template_directory_uri() . '/assets/images/review-page-star.png'; ?> />
                            <?php endfor; ?>
                            <?php if(isset($stars['half'])): ?>
                              <img src=<?php echo get_template_directory_uri() . '/assets/images/review-page-' .$stars['half'].'.png'; ?> />
                            <?php endif; ?>
                          </div>
                        </div>

                        <p class="text-caption text-gray-medium reviewed-by">Reviewed by <?php echo $review['name'][0]; ?> on <?php echo $review['date'][0]; ?></p>
                      </div>
                      <div class="review-body text-gray-medium text-caption">
                        <?php echo $review['review'][0]; ?>

                      </div>
                      <div class="img-wrap logo-wrap mt-3">
                        <img src="<?php echo $review['logo'][0]['image']; ?>" alt="<?php echo $review['logo'][0]['alt']; ?>"
                          >
                      </div>
                    </a>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <div class="mt-4 d-flex justify-content-center">

            <button class="button-secondary show-reviews-button w-md-auto w-100">Show more</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
